import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/helper/string_format_helper.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/data/model/reward/reward_response_model.dart';

class RewardUsedCard extends StatelessWidget {
  final UserReward reward;
  final String currencySym;

  const RewardUsedCard({super.key, required this.reward, required this.currencySym});

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: Dimensions.space10, vertical: 10),
      decoration: BoxDecoration(
        color: MyColor.colorWhite,
      ),
      child: Row(
        children: [
          Expanded(
            flex: 2,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  "${(reward.reward?.name ?? "").tr.replaceAll("_", " ").toCapitalized()} | $currencySym${StringConverter.formatNumber(reward.pointsUsed ?? "0.0")} ",
                  style: semiBoldDefault.copyWith(),
                  maxLines: 3,
                  overflow: TextOverflow.ellipsis,
                ),
                Text("$currencySym${StringConverter.formatNumber(reward.pointsUsed ?? "0.0")}", style: lightDefault.copyWith()),
                Text(reward.expiresAt ?? "", style: lightDefault.copyWith(color: MyColor.colorGrey)),
                Text("${MyStrings.expiredIn.tr} ${reward.reward?.validityDays} ${MyStrings.days.tr}", style: semiBoldDefault.copyWith(color: MyColor.colorRed)),
              ],
            ),
          ),
          const SizedBox(width: Dimensions.space10),
          Text("- ${reward.pointsUsed} ${MyStrings.points.tr}", style: semiBoldDefault.copyWith(color: MyColor.redCancelTextColor)),
        ],
      ),
    );
  }
}
